package app.firezone.synk.network.Fragments;

import android.content.Intent;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;


import com.denzcoskun.imageslider.ImageSlider;
import com.denzcoskun.imageslider.constants.ScaleTypes;
import com.denzcoskun.imageslider.interfaces.ItemClickListener;
import com.denzcoskun.imageslider.models.SlideModel;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.squareup.picasso.Picasso;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.Activities.HelpActivity;
import app.firezone.synk.network.Activities.NotificationActivity;
import app.firezone.synk.network.Activities.ProfileActivity;
import app.firezone.synk.network.Activities.ScoreActivity;
import app.firezone.synk.network.Activities.WalletActivity;
import app.firezone.synk.network.Adapter.GameAdapter;
import app.firezone.synk.network.Adapter.HomeNotificationAdapter;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.FragmentHomeBinding;
import app.firezone.synk.network.model.BannerModel;
import app.firezone.synk.network.model.GameModel;
import app.firezone.synk.network.model.NotificationModel;
import app.firezone.synk.network.model.SliderModel;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.util.ArrayList;
import java.util.List;


public class HomeFragment extends Fragment {

    FragmentHomeBinding binding;

    RecyclerView esportRecycler, classicRecycler, notifyRecycler;
    ImageSlider imageSlider;

    ArrayList<NotificationModel> mlist =  new ArrayList<>();

    HomeNotificationAdapter notificationAdapter;

    ConstraintLayout cardView, constraintLayout7, constraintLayout6, constraintLayout2;

    GameAdapter adapter;
    ArrayList<GameModel> models;

    private MyApi myApi;

    private View shimmerLayout;
    private View contentInclude;
    private ShimmerFrameLayout shimmerFrame;




    public View onCreateView(@NonNull LayoutInflater inflater,
                             ViewGroup container, Bundle savedInstanceState) {
        binding = FragmentHomeBinding.inflate(inflater, container, false);
        View root = binding.getRoot();

        imageSlider =  root.findViewById(R.id.imageSlider);
        esportRecycler = root.findViewById(R.id.gameRecy);
        classicRecycler = root.findViewById(R.id.classicGameRecy);
        notifyRecycler = root.findViewById(R.id.notifyRecy);

        shimmerFrame = root.findViewById(R.id.shimmer_layout);
        shimmerFrame.setVisibility(View.VISIBLE);
        shimmerFrame.startShimmer();

        binding.homeMainLayout.setVisibility(View.GONE);


        final List<SlideModel> remoteImage = new ArrayList<>();
        final List<String> webUrls = new ArrayList<>();


        myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<List<SliderModel>> call = myApi.fetchSlider();

        call.enqueue(new Callback<List<SliderModel>>() {
            @Override
            public void onResponse(Call<List<SliderModel>> call, Response<List<SliderModel>> response) {

                if (response.isSuccessful() && response.body() != null && !response.body().isEmpty()) {
                    List<SliderModel> sliderList = response.body();

                    for (SliderModel slider : sliderList) {
                        if (slider != null && slider.getUrl() != null) {
                            remoteImage.add(new SlideModel(slider.getUrl(), ScaleTypes.FIT));
                            webUrls.add(slider.getWeburl());
                        }
                    }

                    if (!remoteImage.isEmpty()) {
                        imageSlider.setImageList(remoteImage, ScaleTypes.FIT);

                        imageSlider.setItemClickListener(new ItemClickListener() {
                            @Override
                            public void doubleClick(int i) {
                                Toast.makeText(getContext(), "Double click", Toast.LENGTH_SHORT).show();
                            }

                            @Override
                            public void onItemSelected(int position) {
                                if (position < webUrls.size()) {
                                    String webUrl = webUrls.get(position);
                                    if (webUrl != null && !webUrl.isEmpty()) {
                                        Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(webUrl));
                                        getContext().startActivity(browserIntent);
                                    } else {
                                        Toast.makeText(getContext(), "No URL found for this slide", Toast.LENGTH_SHORT).show();
                                    }
                                }
                            }
                        });
                    } else {
                        setDefaultSlider(); // even if list is present but empty after filtering
                    }

                } else {
                    setDefaultSlider(); // empty or unsuccessful
                }
            }

            @Override
            public void onFailure(Call<List<SliderModel>> call, Throwable t) {
                Toast.makeText(getContext(), "Failed: " + t.getMessage(), Toast.LENGTH_SHORT).show();
                setDefaultSlider(); // fallback on failure
            }

            private void setDefaultSlider() {
                // Use a local drawable image as default
                remoteImage.clear();
                webUrls.clear();
                remoteImage.add(new SlideModel(R.drawable.loading_img, ScaleTypes.FIT));
                imageSlider.setImageList(remoteImage, ScaleTypes.FIT);
            }
        });


        binding.constraintLayout2.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(getContext(), ProfileActivity.class));
            }
        });


        binding.constraintLayout5.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(getContext(), WalletActivity.class));
            }
        });


        binding.constraintLayout6.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(getContext(), ScoreActivity.class));
            }
        });


        binding.constraintLayout7.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(getContext(), HelpActivity.class));
            }
        });

        binding.cardViewNotify.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                startActivity(new Intent(getContext(), NotificationActivity.class));
            }
        });


        myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<List<BannerModel>> call2 = myApi.fetchBanner();

        call2.enqueue(new Callback<List<BannerModel>>() {
            @Override
            public void onResponse(Call<List<BannerModel>> call, Response<List<BannerModel>> response) {
                if (response.isSuccessful() && response.body() != null) {
                    List<BannerModel> bannerList = response.body();

                    if (!bannerList.isEmpty()) {
                        BannerModel model = bannerList.get(0);

                        if (model != null && model.getUrl() != null && binding != null && binding.bannerImg != null) {
                            Picasso.get()
                                    .load(model.getUrl())
                                    .placeholder(R.drawable.loading_img)
                                    .error(R.drawable.loading_img) // in case URL fails to load
                                    .into(binding.bannerImg);
                        } else {
                            setDefaultBanner();
                        }
                    } else {
                        setDefaultBanner();
                    }
                } else {
                    setDefaultBanner();
                }
            }

            @Override
            public void onFailure(Call<List<BannerModel>> call, Throwable t) {
                setDefaultBanner();
            }

            private void setDefaultBanner() {
                if (binding != null && binding.bannerImg != null) {
                    binding.bannerImg.setImageResource(R.drawable.loading_img);
                }
            }
        });

        // Set up RecyclerView
        GridLayoutManager layoutManager = new GridLayoutManager(getContext(), 3);
        esportRecycler.setLayoutManager(layoutManager);

        int spacing = getResources().getDimensionPixelSize(R.dimen.game_item_spacing); // e.g., 8dp
        esportRecycler.addItemDecoration(new GridSpacingItemDecoration(3, spacing, true));


        // API call to fetch games
        myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<ArrayList<GameModel>> game = myApi.fetchGameSetting();

        game.enqueue(new Callback<ArrayList<GameModel>>() {
            @Override
            public void onResponse(Call<ArrayList<GameModel>> call, Response<ArrayList<GameModel>> response) {
                if (response.isSuccessful() && response.body() != null && !response.body().isEmpty()) {
                    ArrayList<GameModel> models = response.body();
                    GameAdapter adapter = new GameAdapter(getContext(), models);
                    esportRecycler.setLayoutManager(new GridLayoutManager(getContext(), 3));
                    esportRecycler.setAdapter(adapter);

                    if (binding != null) {
                        shimmerFrame.stopShimmer();
                        shimmerFrame.setVisibility(View.GONE);
                        binding.homeMainLayout.setVisibility(View.VISIBLE);
                    }
                } else {
                    showFallbackGameList();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<GameModel>> call, Throwable throwable) {
                showFallbackGameList();
            }

            private void showFallbackGameList() {
                ArrayList<GameModel> fallbackList = new ArrayList<>();
                fallbackList.add(new GameModel(
                        "Default Game",
                        "https://admin-tournament.yadavatech.com/storage/Match/20250425081329.jpg",
                        "com.ytech.tournament",
                        "1.5K+ Played",
                        "Esports"
                ));
                GameAdapter adapter = new GameAdapter(getContext(), fallbackList);
                // esportRecycler.setLayoutManager(new GridLayoutManager(getContext(), 3));
                esportRecycler.setAdapter(adapter);

                if (binding != null) {
                    shimmerFrame.stopShimmer();
                    shimmerFrame.setVisibility(View.GONE);
                    binding.homeMainLayout.setVisibility(View.VISIBLE);
                }

            }
        });




        LinearLayoutManager layoutManager4 = new LinearLayoutManager(getContext());
        notifyRecycler.setLayoutManager(layoutManager4);

        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<NotificationModel> notifications = myApi.fetchLatestNotification(); // Single item

        notifications.enqueue(new Callback<NotificationModel>() {
            @Override
            public void onResponse(Call<NotificationModel> call, Response<NotificationModel> response) {
                if (response.isSuccessful() && response.body() != null) {
                    mlist.clear();
                    mlist.add(response.body()); // ✅ Add the one item

                    notificationAdapter = new HomeNotificationAdapter(getContext(), mlist);
                    notifyRecycler.setAdapter(notificationAdapter);
                    notificationAdapter.notifyDataSetChanged();
                } else {
                    //Toast.makeText(getContext(), "No notifications found", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<NotificationModel> call, Throwable throwable) {
                //  Toast.makeText(getContext(), "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });




        return root;
    }

    public class GridSpacingItemDecoration extends RecyclerView.ItemDecoration {

        private final int spanCount;
        private final int spacing;
        private final boolean includeEdge;

        public GridSpacingItemDecoration(int spanCount, int spacing, boolean includeEdge) {
            this.spanCount = spanCount;
            this.spacing = spacing;
            this.includeEdge = includeEdge;
        }

        @Override
        public void getItemOffsets(Rect outRect, View view, RecyclerView parent,
                                   RecyclerView.State state) {
            int position = parent.getChildAdapterPosition(view); // item position
            int column = position % spanCount; // item column

            if (includeEdge) {
                outRect.left = spacing - column * spacing / spanCount;
                outRect.right = (column + 1) * spacing / spanCount;

                if (position < spanCount) { // top edge
                    outRect.top = spacing;
                }
                outRect.bottom = spacing; // item bottom
            } else {
                outRect.left = column * spacing / spanCount;
                outRect.right = spacing - (column + 1) * spacing / spanCount;
                if (position >= spanCount) {
                    outRect.top = spacing; // item top
                }
            }
        }
    }


    public class EqualSpacingItemDecoration extends RecyclerView.ItemDecoration {
        private final int spacing;

        public EqualSpacingItemDecoration(int spacing) {
            this.spacing = spacing;
        }

        @Override
        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            outRect.left = spacing;
            outRect.right = spacing;
            outRect.top = spacing;
            outRect.bottom = spacing;
        }
    }


    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }



}